class Item_Vampire extends TournamentPickup;

var int VampireTime;

event float BotDesireability(Pawn Bot)
{
	return (0); 
}

auto state Pickup
{	
	function Touch( actor Other )
		{
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			MonsterPRI(PlayerPawn(Other).PlayerReplicationInfo).VampireTime += VampireTime;
			PlayerPawn(Other).ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	

		}
	function BeginState()
		{
		SetTimer(1.0,True);
		}
}

defaultproperties
{
     bDisplayableInv=True
     PickupMessage="You now feed from your frags!"
     ItemName="Vampire"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'HealthItem'
     MaxDesireability=2.000000
     PickupSound=Sound'VampireSound'
     Mesh=Mesh'HealthItem'
     AmbientGlow=64
     MultiSkins(0)=Texture'Item_Vampire'
     CollisionRadius=16.00000
     CollisionHeight=16.00000
     bCollideWhenPlacing=True
     bRotatingPickup=True
     RotationRate=(Roll=32768)
     RotationRate=(Pitch=26000)
     RotationRate=(Yaw=19200)
     LightEffect=LE_Shock
     LightBrightness=64
     LightHue=42
     LightRadius=16
     LightSaturation=127
     LightType=LT_Steady
     Charge=20
     ArmorAbsorption=75
     bIsAnArmor=True
     RespawnTime=0
}
